package ru.yandex.http.util.nio.client;

import java.util.List;
import java.util.function.Function;

import org.apache.http.HttpHost;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class FailoverRetryContextFactory implements RetryContextFactory {
    private final List<HttpHost> hosts;
    private final Function<
        ? super HttpHost,
        ? extends HttpAsyncRequestProducer>
        producerFactory;

    public FailoverRetryContextFactory(
        final List<HttpHost> hosts,
        final Function<? super HttpHost, ? extends HttpAsyncRequestProducer>
        producerFactory)
    {
        this.hosts = hosts;
        this.producerFactory = producerFactory;
    }

    @Override
    public <T> FailoverRetryContext<T> create(
        final RequestContext<T> requestContext,
        final ClientContext clientContext)
    {
        return
            new FailoverRetryContext<>(
                new MultiTargetRequestContext<>(
                    requestContext,
                    clientContext,
                    hosts),
                producerFactory);
    }
}

