package ru.yandex.http.util.nio.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.http.nio.client.methods.ZeroCopyConsumer;
import org.apache.http.protocol.HttpContext;

public abstract class FileConsumer<T> extends ZeroCopyConsumer<T> {
    private final AtomicBoolean completed = new AtomicBoolean();
    private final File file;

    protected FileConsumer(final File file) throws FileNotFoundException {
        super(file);
        this.file = file;
    }

    @Override
    protected T buildResult(final HttpContext context) throws Exception {
        T result = super.buildResult(context);
        completed.set(true);
        return result;
    }

    @SuppressWarnings("EmptyCatch")
    @Override
    protected void releaseResources() {
        super.releaseResources();
        if (completed.compareAndSet(false, true)) {
            try {
                Files.deleteIfExists(file.toPath());
            } catch (IOException e) {
            }
        }
    }
}

