package ru.yandex.http.util.nio.client;

import java.io.File;
import java.io.FileNotFoundException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;


public class FileCopyConsumerFactory
        implements HttpAsyncResponseConsumerFactory<File>
{

    private File file;

    public FileCopyConsumerFactory(
            File file)
    {
        this.file = file;
    }

    @Override
    public HttpAsyncResponseConsumer<File> create(
            final HttpAsyncRequestProducer producer,
            final HttpResponse response)
            throws HttpException, FileNotFoundException {
        // TODO: If file already exists - we need check that old file will be truncated
        return new FileGetConsumer(this.file);
//        try {
//            return new FileGetConsumer(this.file);
//            return new ZeroCopyConsumer<File>(this.file) {
//
//                @Override
//                protected File process(
//                        final HttpResponse response,
//                        final File file,
//                        final ContentType contentType) throws Exception {
//                    if (response.getStatusLine().getStatusCode() != HttpStatus.SC_OK) {
//                        throw new HttpResponseException(response.getStatusLine().getStatusCode(),
//                                "Get file failed: " + response.getStatusLine());
//                    }
//                    return file;
//                }
//
//            };
//        } catch (FileNotFoundException e) {
//            e.printStackTrace();
//            // TODO: if path not founded?
//
//            return null;
//        }
    }
}

