package ru.yandex.http.util.nio.client;

import java.io.File;
import java.io.FileNotFoundException;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.ContentType;

import ru.yandex.http.util.HttpStatusPredicates;


public class FileGetConsumer extends FileConsumer<File> {

    public FileGetConsumer(
            File file) throws FileNotFoundException {
        super(file);
    }


    @Override
    protected File process(
            final HttpResponse response,
            final File file,
            final ContentType contentType) throws Exception {
        if (HttpStatusPredicates.OK.test(response.getStatusLine().getStatusCode())) {
            return file;
        } else {
            throw new HttpResponseException(response.getStatusLine().getStatusCode(),
                    "Get file failed: " + response.getStatusLine());
        }
    }
}
