package ru.yandex.http.util.nio.client;

import java.io.IOException;
import java.util.concurrent.Future;

import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

public class FilterCloseableHttpAsyncClient extends CloseableHttpAsyncClient {
    protected final CloseableHttpAsyncClient client;

    public FilterCloseableHttpAsyncClient(
        final CloseableHttpAsyncClient client)
    {
        this.client = client;
    }

    @Override
    public void start() {
        client.start();
    }

    @Override
    public void close() throws IOException {
        client.close();
    }

    @Override
    public boolean isRunning() {
        return client.isRunning();
    }

    // CSOFF: ParameterNumber
    @Override
    public <T> Future<T> execute(
        final HttpAsyncRequestProducer requestProducer,
        final HttpAsyncResponseConsumer<T> responseConsumer,
        final HttpContext context,
        final FutureCallback<T> callback)
    {
        return client.execute(
            requestProducer,
            responseConsumer,
            context,
            callback);
    }
    // CSON: ParameterNumber
}

