package ru.yandex.http.util.nio.client;

import java.util.function.BiFunction;

import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;

public class FilterRequestsListener implements RequestsListener {
    private final RequestsListener listener;

    public FilterRequestsListener(final RequestsListener listener) {
        this.listener = listener;
    }

    @Override
    public String toString() {
        return listener.toString();
    }

    @Override
    public boolean isEmpty() {
        return listener.isEmpty();
    }

    @Override
    public long totalTime() {
        return listener.totalTime();
    }

    @Override
    public String details() {
        return listener.details();
    }

    @Override
    public <T> FutureCallback<? super T> createCallbackFor(
        final HttpRoute route,
        final HttpRequest request,
        final HttpContext context)
    {
        return listener.createCallbackFor(route, request, context);
    }

    @Override
    public <T> FutureCallback<? super T> createCallbackFor(
        final HttpRoute route,
        final String request,
        final BiFunction<RequestData, ? super T, RequestInfo> responseConverter)
    {
        return listener.createCallbackFor(route, request, responseConverter);
    }
}

