package ru.yandex.http.util.nio.client;

import java.util.TimerTask;
import java.util.concurrent.Future;

import org.apache.http.concurrent.FutureCallback;

public class FilterRetryContext<T> implements RetryContext<T> {
    private final RetryContext<T> context;

    public FilterRetryContext(final RetryContext<T> context) {
        this.context = context;
    }

    @Override
    public Future<T> sendRequest(final FutureCallback<T> callback) {
        return context.sendRequest(callback);
    }

    @Override
    public long nextRetryInterval(final Exception e) {
        return context.nextRetryInterval(e);
    }

    @Override
    public void scheduleRetry(final TimerTask task, final long delay) {
        context.scheduleRetry(task, delay);
    }
}

