package ru.yandex.http.util.nio.client;

import java.util.function.Function;

import org.apache.http.HttpHost;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class HostToBasicRetryContext<T>
    implements Function<HttpHost, RetryContext<T>>
{
    private final RequestContext<T> requestContext;
    private final ClientContext clientContext;
    private final Function<
        ? super HttpHost,
        ? extends HttpAsyncRequestProducer>
        producerGenerator;

    public HostToBasicRetryContext(
        final RequestContext<T> requestContext,
        final ClientContext clientContext,
        final Function<? super HttpHost, ? extends HttpAsyncRequestProducer>
        producerGenerator)
    {
        this.requestContext = requestContext;
        this.clientContext = clientContext;
        this.producerGenerator = producerGenerator;
    }

    @Override
    public RetryContext<T> apply(final HttpHost host) {
        return new BasicRetryContext<>(
            requestContext,
            clientContext,
            () -> producerGenerator.apply(host));
    }
}

