package ru.yandex.http.util.nio.client;

import java.util.function.Function;

import org.apache.http.HttpHost;

public class HostToDeadlineRetryContext<T>
    implements Function<HttpHost, RetryContext<T>>
{
    private final Function<? super HttpHost, ? extends RetryContext<T>> next;
    private final long deadline;

    public HostToDeadlineRetryContext(
        final Function<? super HttpHost, ? extends RetryContext<T>> next,
        final long deadline)
    {
        this.next = next;
        this.deadline = deadline;
    }

    @Override
    public RetryContext<T> apply(final HttpHost host) {
        return new DeadlineRetryContext<>(next.apply(host), deadline);
    }
}

