package ru.yandex.http.util.nio.client;

import java.util.function.Supplier;

import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.SynchronizedHttpContext;
import ru.yandex.http.util.client.FakeAuthState;

public class HttpClientContextGenerator
    implements Supplier<HttpClientContext>
{
    private final RequestConfig requestConfig;

    public HttpClientContextGenerator(final RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    @Override
    public HttpClientContext get() {
        HttpContext context = new SynchronizedHttpContext();
        context.setAttribute(HttpClientContext.REQUEST_CONFIG, requestConfig);
        context.setAttribute(
            HttpClientContext.TARGET_AUTH_STATE,
            FakeAuthState.INSTANCE);
        context.setAttribute(
            HttpClientContext.PROXY_AUTH_STATE,
            FakeAuthState.INSTANCE);
        return new HttpClientContext(context);
    }
}

