package ru.yandex.http.util.nio.client;

import java.util.concurrent.Future;

import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.FutureCallbackChain;

public class ListeningCloseableHttpAsyncClient
    extends FilterCloseableHttpAsyncClient
{
    public ListeningCloseableHttpAsyncClient(
        final CloseableHttpAsyncClient client)
    {
        super(client);
    }

    @Override
    public <T> Future<T> execute(
        final HttpAsyncRequestProducer requestProducer,
        final HttpAsyncResponseConsumer<T> responseConsumer,
        final HttpContext context,
        FutureCallback<T> callback)
    {
        RequestsListener listener =
            (RequestsListener) context.getAttribute(RequestsListener.LISTENER);
        if (listener != null) {
            FutureCallbackChain<T> proxyCallback =
                new FutureCallbackChain<>(callback);
            callback = proxyCallback;
            RequestObserver requestObserver =
                new Observer<>(listener, context, proxyCallback);
            requestObserver.subscribe(context);
        }
        return super.execute(
            requestProducer,
            responseConsumer,
            context,
            callback);
    }

    private static class Observer<T> implements RequestObserver {
        private final RequestsListener listener;
        private final HttpContext context;
        private final FutureCallbackChain<T> proxyCallback;

        Observer(
            final RequestsListener listener,
            final HttpContext context,
            final FutureCallbackChain<T> proxyCallback)
        {
            this.listener = listener;
            this.context = context;
            this.proxyCallback = proxyCallback;
        }

        @Override
        public void notify(final HttpRoute route, final HttpRequest request) {
            proxyCallback.addFirst(
                listener.createCallbackFor(route, request, context));
        }
    }
}

