package ru.yandex.http.util.nio.client;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.ProtocolException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.protocol.HttpAsyncRequestExecutor;

public class LoggingAsyncRequestExecutor extends HttpAsyncRequestExecutor {
    private final Logger logger;

    public LoggingAsyncRequestExecutor(final Logger logger) {
        this.logger = logger;
    }

    @Override
    public void exception(
        final NHttpClientConnection conn,
        final Exception exception)
    {
        logger.log(Level.WARNING, "Exception occured on " + conn, exception);
        if (exception instanceof ProtocolException) {
            super.exception(conn, new ClientProtocolException(exception));
        } else {
            super.exception(conn, exception);
        }
    }

    @Override
    protected void log(final Exception exception) {
        logger.log(Level.WARNING, "Exception occured", exception);
    }
}

