package ru.yandex.http.util.nio.client;

import java.util.concurrent.Future;
import java.util.function.Supplier;

import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class MultiProxyRetryContext<T> extends MultiTargetRetryContextBase<T> {
    private final Supplier<? extends HttpAsyncRequestProducer> producerFactory;

    public MultiProxyRetryContext(
        final MultiTargetRequestContext<T> context,
        final Supplier<? extends HttpAsyncRequestProducer> producerFactory)
    {
        super(context);
        this.producerFactory = producerFactory;
    }

    @Override
    protected Future<T> sendRequest(
        final HttpHost host,
        final FutureCallback<T> callback)
    {
        HttpClientContext context = requestContext.contextSupplier().get();
        context.setRequestConfig(
            RequestConfig.copy(context.getRequestConfig())
                .setProxy(host)
                .build());
        return requestContext.sendRequest(
            producerFactory.get(),
            context,
            callback);
    }
}

