package ru.yandex.http.util.nio.client;

import java.util.List;
import java.util.function.Supplier;

import org.apache.http.HttpHost;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class MultiProxyRetryContextFactory implements RetryContextFactory {
    private final List<HttpHost> hosts;
    private final Supplier<? extends HttpAsyncRequestProducer> producerFactory;

    public MultiProxyRetryContextFactory(
        final List<HttpHost> hosts,
        final Supplier<? extends HttpAsyncRequestProducer> producerFactory)
    {
        this.hosts = hosts;
        this.producerFactory = producerFactory;
    }

    @Override
    public <T> MultiProxyRetryContext<T> create(
        final RequestContext<T> requestContext,
        final ClientContext clientContext)
    {
        return
            new MultiProxyRetryContext<>(
                new MultiTargetRequestContext<>(
                    requestContext,
                    clientContext,
                    hosts),
                producerFactory);
    }
}

