package ru.yandex.http.util.nio.client;

import java.util.List;

import org.apache.http.HttpHost;

public class MultiTargetRequestContext<T> {
    private final RequestContext<T> requestContext;
    private final ClientContext clientContext;
    private final List<HttpHost> hosts;

    public MultiTargetRequestContext(
        final RequestContext<T> requestContext,
        final ClientContext clientContext,
        final List<HttpHost> hosts)
    {
        this.requestContext = requestContext;
        this.clientContext = clientContext;
        this.hosts = hosts;
    }

    public RequestContext<T> requestContext() {
        return requestContext;
    }

    public ClientContext clientContext() {
        return clientContext;
    }

    public List<HttpHost> hosts() {
        return hosts;
    }
}
