package ru.yandex.http.util.nio.client;

import java.util.concurrent.Future;
import java.util.function.Supplier;

import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.LazyAsyncResponseConsumer;

public class RequestContext<T> {
    protected final HttpAsyncClient client;
    protected final HttpAsyncResponseConsumerFactory<T> consumerFactory;
    protected final Supplier<? extends HttpClientContext> contextSupplier;

    public RequestContext(
        final HttpAsyncClient client,
        final HttpAsyncResponseConsumerFactory<T> consumerFactory,
        final Supplier<? extends HttpClientContext> contextSupplier)
    {
        this.client = client;
        this.consumerFactory = consumerFactory;
        this.contextSupplier = contextSupplier;
    }

    public Supplier<? extends HttpClientContext> contextSupplier() {
        return contextSupplier;
    }

    public Future<T> sendRequest(
        final HttpAsyncRequestProducer requestProducer,
        final HttpClientContext context,
        final FutureCallback<T> callback)
    {
        return client.execute(
            requestProducer,
            new LazyAsyncResponseConsumer<>(consumerFactory, requestProducer),
            context,
            callback);
    }
}

