package ru.yandex.http.util.nio.client;

import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

import ru.yandex.http.util.RequestToString;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.client.pool.TimedConnection;
import ru.yandex.util.timesource.TimeSource;

public class RequestData {
    private final long startTime = TimeSource.INSTANCE.currentTimeMillis();
    private final HttpRoute route;
    private final String request;
    private final HttpContext context;

    RequestData(
        final HttpRoute route,
        final HttpRequest request,
        final HttpContext context)
    {
        this(
            route,
            new String(
                RequestToString.requestToStringBuilder(
                    "",
                    request,
                    0,
                    YandexHeaders.DEFAULT_HIDDEN_HEADERS)),
            context);
    }

    RequestData(
        final HttpRoute route,
        final String request,
        final HttpContext context)
    {
        this.route = route;
        this.request = request;
        this.context = context;
    }

    public long startTime() {
        return startTime;
    }

    public HttpRoute route() {
        return route;
    }

    public String request() {
        return request;
    }

    public HttpResponse response() {
        Object resp = context.getAttribute(HttpCoreContext.HTTP_RESPONSE);
        return (HttpResponse) resp;
    }

    public TimedConnection connection() {
        Object conn = context.getAttribute(HttpCoreContext.HTTP_CONNECTION);
        return (TimedConnection) conn;
    }

    public Object requestsGroup() {
        return context.getAttribute(RequestsListener.REQUESTS_GROUP);
    }
}

