package ru.yandex.http.util.nio.client;

import org.apache.http.HttpRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;

public interface RequestObserver {
    String REQUEST_OBSERVER = "ru.yandex.http.util.nio.client.RequestObserver";

    void notify(HttpRoute route, HttpRequest request);

    default void subscribe(HttpContext context) {
        RequestObserver oldObserver =
            (RequestObserver) context.getAttribute(REQUEST_OBSERVER);
        RequestObserver newObserver;
        if (oldObserver == null) {
            newObserver = this;
        } else {
            newObserver = new DuplexRequestObserver(oldObserver, this);
        }
        context.setAttribute(REQUEST_OBSERVER, newObserver);
    }
}

