package ru.yandex.http.util.nio.client;

import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;

public enum RequestReporter implements HttpRequestInterceptor {
    INSTANCE;

    @Override
    public void process(final HttpRequest request, final HttpContext context) {
        RequestObserver observer = (RequestObserver) context.getAttribute(
            RequestObserver.REQUEST_OBSERVER);
        if (observer != null) {
            HttpRoute route =
                (HttpRoute) context.getAttribute(HttpClientContext.HTTP_ROUTE);
            if (route != null) {
                observer.notify(route, request);
            }
        }
    }
}

