package ru.yandex.http.util.nio.client;

import java.util.function.BiFunction;
import java.util.function.Supplier;

import org.apache.http.HttpRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.FillingHttpContextSupplier;

public interface RequestsListener {
    String LISTENER = "ru.yandex.http.util.nio.client.RequestsListener";
    String REQUESTS_GROUP = "ru.yandex.http.util.nio.client.RequestsGroup";

    boolean isEmpty();

    long totalTime();

    String details();

    <T> FutureCallback<? super T> createCallbackFor(
        HttpRoute route,
        HttpRequest request,
        HttpContext context);

    <T> FutureCallback<? super T> createCallbackFor(
        HttpRoute route,
        String request,
        BiFunction<RequestData, ? super T, RequestInfo> responseConverter);

    default <T extends AbstractAsyncClient<T>>
        Supplier<? extends HttpClientContext>
        createContextGeneratorFor(AbstractAsyncClient<T> client)
    {
        return adjustContextGenerator(client.httpClientContextGenerator());
    }

    default Supplier<? extends HttpClientContext> adjustContextGenerator(
        Supplier<? extends HttpClientContext> contextGenerator)
    {
        return new FillingHttpContextSupplier<>(
            new FillingHttpContextSupplier<>(
                contextGenerator,
                REQUESTS_GROUP,
                new Object()),
            LISTENER,
            this);
    }
}

