package ru.yandex.http.util.nio.client;

import java.util.function.Supplier;

import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;

public class SessionTimeoutRequestContextFactory
    implements RequestContextFactory
{
    private final int timeout;

    public SessionTimeoutRequestContextFactory(final int timeout) {
        this.timeout = timeout;
    }

    @Override
    public <T> RequestContext<T> create(
        final CloseableHttpAsyncClient client,
        final HttpAsyncResponseConsumerFactory<T> consumerFactory,
        final Supplier<? extends HttpClientContext> contextGenerator)
    {
        return new SessionTimeoutRequestContext<>(
            client,
            consumerFactory,
            contextGenerator,
            timeout);
    }
}

