package ru.yandex.http.util.nio.client.pool;

import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.Future;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.function.GenericAutoCloseable;

public interface AsyncDnsResolver
    extends GenericAutoCloseable<RuntimeException>
{
    void start();

    Future<InetAddress> resolve(
        String hostname,
        FutureCallback<InetAddress> callback);

    Map<String, Object> status(boolean verbose);
}

