package ru.yandex.http.util.nio.client.pool;

import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;

import org.apache.http.conn.DnsResolver;

public class SingleThreadDnsResolverFactory
    implements Supplier<SingleThreadDnsResolver>
{
    private final DnsResolver dnsResolver;
    private final long dnsTtl;
    private final long dnsUpdateInterval;
    private final ThreadFactory threadFactory;

    // CSOFF: ParameterNumber
    public SingleThreadDnsResolverFactory(
        final DnsResolver dnsResolver,
        final long dnsTtl,
        final long dnsUpdateInterval,
        final ThreadFactory threadFactory)
    {
        this.dnsResolver = dnsResolver;
        this.dnsTtl = dnsTtl;
        this.dnsUpdateInterval = dnsUpdateInterval;
        this.threadFactory = threadFactory;
    }
    // CSON: ParameterNumber

    @Override
    public SingleThreadDnsResolver get() {
        return new SingleThreadDnsResolver(
            dnsResolver,
            dnsTtl,
            dnsUpdateInterval,
            threadFactory);
    }
}

