package ru.yandex.http.util.nio.client.pool;

import ru.yandex.http.util.nio.FilterNHttpClientConnection;

public class TimedConnection extends FilterNHttpClientConnection {
    private final PooledNHttpClientConnection pooledConnection;
    private final long poolWaitStart;
    private final long connectStart;
    private final long connectCompleted;

    public TimedConnection(
        final PooledNHttpClientConnection pooledConnection,
        final long poolWaitStart,
        final long connectStart, // may be 0L
        final long connectCompleted)
    {
        super(pooledConnection);
        this.pooledConnection = pooledConnection;
        this.poolWaitStart = poolWaitStart;
        this.connectStart = connectStart;
        this.connectCompleted = connectCompleted;
    }

    public PooledNHttpClientConnection conn() {
        return pooledConnection;
    }

    public long dnsTime(final long requestStart) {
        return poolWaitStart - requestStart;
    }

    public long poolTime() {
        if (connectStart == 0L) {
            return connectCompleted - poolWaitStart;
        } else {
            return connectStart - poolWaitStart;
        }
    }

    public long connTime() {
        if (connectStart == 0L) {
            return 0L;
        } else {
            return connectCompleted - connectStart;
        }
    }
}

