package ru.yandex.http.util.client;

import java.util.function.IntPredicate;

import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.config.ImmutableRetriesConfig;

public class BasicServiceUnavailableRetryStrategy
    implements ServiceUnavailableRetryStrategy
{
    private final ImmutableRetriesConfig retriesConfig;
    private final IntPredicate serverErrorStatusPredicate;

    public BasicServiceUnavailableRetryStrategy(
        final ImmutableRetriesConfig retriesConfig,
        final IntPredicate serverErrorStatusPredicate)
    {
        this.retriesConfig = retriesConfig;
        this.serverErrorStatusPredicate = serverErrorStatusPredicate;
    }

    @Override
    public boolean retryRequest(
        final HttpResponse response,
        final int executionCount,
        final HttpContext context)
    {
        if (executionCount > retriesConfig.count()) {
            return false;
        } else {
            return serverErrorStatusPredicate.test(
                response.getStatusLine().getStatusCode());
        }
    }

    @Override
    public long getRetryInterval() {
        return retriesConfig.interval();
    }
}

