package ru.yandex.http.util.client;

import java.util.function.Supplier;

import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;

import ru.yandex.util.timesource.TimeSource;

public class DeadlineHttpClientContextSupplier<T extends HttpClientContext>
    implements Supplier<T>
{
    private static final int MIN_TIMEOUT = 10;

    private final Supplier<? extends T> supplier;
    private final long deadline;

    public DeadlineHttpClientContextSupplier(
        final Supplier<? extends T> supplier,
        final long deadline)
    {
        this.supplier = supplier;
        this.deadline = deadline;
    }

    @Override
    public T get() {
        T t = supplier.get();
        long timeLeft = deadline - TimeSource.INSTANCE.currentTimeMillis();
        int timeout;
        if (timeLeft <= MIN_TIMEOUT) {
            // just a little chance
            timeout = MIN_TIMEOUT;
        } else if (timeLeft > Integer.MAX_VALUE) {
            timeout = 0;
        } else {
            timeout = (int) timeLeft;
        }
        t.setRequestConfig(
            RequestConfig.copy(t.getRequestConfig())
                .setConnectTimeout(timeout)
                .setSocketTimeout(timeout)
                .setConnectionRequestTimeout(timeout)
                .build());
        return t;
    }
}

