package ru.yandex.http.util.client;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collections;

import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.config.ImmutableRetriesConfig;

public class DelayHttpRequestRetryHandler
    extends DefaultHttpRequestRetryHandler
{
    private final long delay;

    public DelayHttpRequestRetryHandler(
        final ImmutableRetriesConfig retriesConfig)
    {
        super(
            retriesConfig.count(),
            true,
            Collections.singletonList(UnknownHostException.class));
        delay = retriesConfig.interval();
    }

    @Override
    public boolean retryRequest(
        final IOException exception,
        final int executionCount,
        final HttpContext context)
    {
        boolean retryRequest =
            super.retryRequest(exception, executionCount, context);
        if (retryRequest && delay > 0L) {
            try {
                Thread.sleep(delay);
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return retryRequest;
    }

    @Override
    protected boolean handleAsIdempotent(final HttpRequest request) {
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity =
                ((HttpEntityEnclosingRequest) request).getEntity();
            return entity == null || entity.isRepeatable();
        }
        return true;
    }
}

