package ru.yandex.http.util.client;

import java.util.Queue;

import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;

@SuppressWarnings("deprecation")
public class FakeAuthState extends AuthState {
    public static final FakeAuthState INSTANCE = new FakeAuthState();

    protected FakeAuthState() {
    }

    @Override
    public void setState(final AuthProtocolState state) {
        if (state != null && state != AuthProtocolState.UNCHALLENGED) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void update(
        final AuthScheme authScheme,
        final Credentials credentials)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(final Queue<AuthOption> authOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAuthScheme(final AuthScheme authScheme) {
        if (authScheme != null) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void setCredentials(final Credentials credentials) {
        if (credentials != null) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void setAuthScope(final AuthScope authScope) {
        if (authScope != null) {
            throw new UnsupportedOperationException();
        }
    }
}

