package ru.yandex.http.util.client;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

import org.apache.http.conn.DnsResolver;

public class MapDnsResolver implements DnsResolver {
    private final DnsResolver dnsResolver;
    private final Map<String, String> mapping;

    public MapDnsResolver(
        final DnsResolver dnsResolver,
        final Map<String, String> mapping)
    {
        this.dnsResolver = dnsResolver;
        this.mapping = mapping;
    }

    @Override
    public InetAddress[] resolve(final String host)
        throws UnknownHostException
    {
        String mapped = mapping.getOrDefault(host, host);
        if (mapped.isEmpty()) {
            throw new UnknownHostException("Empty mapping for " + host);
        }
        return dnsResolver.resolve(mapped);
    }
}

