package ru.yandex.http.util.client;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.protocol.HttpContext;

public class PlainHttpRoutePlanner implements HttpRoutePlanner {
    private final HttpHost defaultProxy;

    public PlainHttpRoutePlanner(final HttpHost defaultProxy) {
        this.defaultProxy = defaultProxy;
    }

    @Override
    public HttpRoute determineRoute(
        final HttpHost host,
        final HttpRequest request,
        final HttpContext context)
    {
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = defaultProxy;
        }
        String scheme;
        if (proxy == null) {
            scheme = host.getSchemeName();
        } else {
            scheme = proxy.getSchemeName();
        }
        return new HttpRoute(
            host,
            config.getLocalAddress(),
            proxy,
            "https".equalsIgnoreCase(scheme),
            HttpRoute.TunnelType.PLAIN,
            HttpRoute.LayerType.PLAIN);
    }
}

