package ru.yandex.http.util.client;

import org.apache.http.HttpHeaders;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;

public class PostsRedirectStrategy extends DefaultRedirectStrategy {
    @Override
    protected boolean isRedirectable(final String method) {
        if (HttpPost.METHOD_NAME.equals(method)) {
            return true;
        } else {
            return super.isRedirectable(method);
        }
    }

    @Override
    public HttpUriRequest getRedirect(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws ProtocolException
    {
        HttpUriRequest redirect =
            super.getRedirect(request, response, context);
        redirect.removeHeaders(HttpHeaders.CONTENT_LENGTH);
        redirect.removeHeaders(HttpHeaders.TRANSFER_ENCODING);
        return redirect;
    }
}

