package ru.yandex.http.util.client;

import java.util.Collection;

import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class RequestDefaultHeaders implements HttpRequestInterceptor {
    private final Header[] headers;

    public RequestDefaultHeaders(final Collection<Header> headers) {
        this.headers = headers.toArray(new Header[headers.size()]);
    }

    @Override
    public void process(final HttpRequest request, final HttpContext context) {
        for (Header header: headers) {
            if (request.getFirstHeader(header.getName()) == null) {
                request.addHeader(header);
            }
        }
    }
}

