package ru.yandex.http.util.client;

import org.apache.http.HttpHeaders;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.HeaderUtils;

public enum RequestTargetHost implements HttpRequestInterceptor {
    INSTANCE;

    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;

    @Override
    public void process(final HttpRequest request, final HttpContext context) {
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        if (!request.containsHeader(HttpHeaders.HOST)) {
            RouteInfo route = clientContext.getHttpRoute();
            if (route != null) {
                HttpHost host = route.getProxyHost();
                if (host == null) {
                    host = route.getTargetHost();
                }
                int port = host.getPort();
                String scheme = host.getSchemeName();
                String hostString;
                if ((port == HTTP_PORT && "http".equals(scheme))
                    || (port == HTTPS_PORT && "https".equals(scheme)))
                {
                    hostString = host.getHostName();
                } else {
                    hostString = host.toHostString();
                }
                request.addHeader(
                    HeaderUtils.createHeader(HttpHeaders.HOST, hostString));
            }
        }
    }
}

