package ru.yandex.http.util.client;

import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.http.util.SynchronizedHttpContext;
import ru.yandex.util.timesource.TimeSource;

public class Timings extends AbstractStringBuilderable {
    public static final String TIMINGS = "ru.yandex.http.util.client.timings";

    private final long start = TimeSource.INSTANCE.currentTimeMillis();
    private long beforeConnect;
    private long connectionGot;
    private long requestSent;
    private long responseReceived;

    public HttpClientContext createContext() {
        HttpContext context = new SynchronizedHttpContext();
        context.setAttribute(TIMINGS, this);
        return new HttpClientContext(context);
    }

    public void beforeConnect() {
        beforeConnect = TimeSource.INSTANCE.currentTimeMillis();
    }

    public void connectionGot() {
        connectionGot = TimeSource.INSTANCE.currentTimeMillis();
    }

    public void requestSent() {
        requestSent = TimeSource.INSTANCE.currentTimeMillis();
    }

    public void responseReceived() {
        responseReceived = TimeSource.INSTANCE.currentTimeMillis();
    }

    public long startTime() {
        return start;
    }

    public long pool() {
        if (beforeConnect == 0L) {
            return connectionGot - start;
        } else {
            return beforeConnect - start;
        }
    }

    public long conn() {
        if (beforeConnect == 0L) {
            return 0;
        } else {
            return connectionGot - beforeConnect;
        }
    }

    public long send() {
        return requestSent - connectionGot;
    }

    public long recv() {
        return responseReceived - requestSent;
    }

    public long total() {
        return responseReceived - start;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append(pool());
        sb.append(' ');
        sb.append(conn());
        sb.append(' ');
        sb.append(send());
        sb.append(' ');
        sb.append(recv());
        sb.append(' ');
        sb.append(total());
        sb.append(' ');
        sb.append('m');
        sb.append('s');
    }
}

