package ru.yandex.http.util.client;

import java.io.IOException;

import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

public class TimingsHttpRequestExecutor extends HttpRequestExecutor {
    @Override
    protected HttpResponse doSendRequest(
        final HttpRequest request,
        final HttpClientConnection conn,
        final HttpContext context)
        throws HttpException, IOException
    {
        Timings timings =
            (Timings) context.getAttribute(Timings.TIMINGS);
        if (timings != null) {
            timings.connectionGot();
        }
        HttpResponse response = super.doSendRequest(request, conn, context);
        if (timings != null) {
            timings.requestSent();
            if (response != null) {
                timings.responseReceived();
            }
        }
        return response;
    }

    @Override
    protected HttpResponse doReceiveResponse(
        final HttpRequest request,
        final HttpClientConnection conn,
        final HttpContext context)
        throws HttpException, IOException
    {
        HttpResponse response =
            super.doReceiveResponse(request, conn, context);
        Timings timings =
            (Timings) context.getAttribute(Timings.TIMINGS);
        if (timings != null) {
            timings.responseReceived();
        }
        return response;
    }
}

