package ru.yandex.http.util.client;

import java.io.IOException;

import org.apache.http.HttpClientConnection;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class TimingsPoolingHttpClientConnectionManager
    extends PoolingHttpClientConnectionManager
{
    public TimingsPoolingHttpClientConnectionManager(
        final SSLConnectionSocketFactory sslConnectionSocketFactory,
        final DnsResolver dnsResolver)
    {
        super(
            RegistryBuilder.<ConnectionSocketFactory>create()
                .register(
                    "http",
                    PlainConnectionSocketFactory.getSocketFactory())
                .register("https", sslConnectionSocketFactory)
                .build(),
            dnsResolver);
    }

    //CSOFF: ParameterNumber
    @Override
    public void connect(
        final HttpClientConnection managedConn,
        final HttpRoute route,
        final int connectTimeout,
        final HttpContext context)
        throws IOException
    {
        Timings timings = (Timings) context.getAttribute(Timings.TIMINGS);
        if (timings != null) {
            timings.beforeConnect();
        }
        super.connect(managedConn, route, connectTimeout, context);
    }
    //CSON: ParameterNumber
}

