package ru.yandex.http.util.client.measurable;

import java.io.IOException;

import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

public class MeasurableHttpRequestExecutor extends HttpRequestExecutor {
    @Override
    protected HttpResponse doSendRequest(
        final HttpRequest request,
        final HttpClientConnection conn,
        final HttpContext context) throws IOException, HttpException
    {
        Measurer m = Measurer.getMeasurer(context);

        if (m != null) {
            m.snapshot(Measurer.Event.BEFORE_SEND);
        }

        HttpResponse ret = super.doSendRequest(request, conn, context);

        if (m != null) {
            m.snapshot(Measurer.Event.AFTER_SEND);
        }

        return ret;
    }

    @Override
    protected HttpResponse doReceiveResponse(
        final HttpRequest request,
        final HttpClientConnection conn,
        final HttpContext context) throws HttpException, IOException
    {
        Measurer m = Measurer.getMeasurer(context);

        if (m != null) {
            m.snapshot(Measurer.Event.BEFORE_RECEIVE);
        }

        HttpResponse ret = super.doReceiveResponse(request, conn, context);

        if (m != null) {
            m.snapshot(Measurer.Event.AFTER_RECEIVE);
        }

        return ret;
    }
}

