package ru.yandex.http.util.client.measurable;

import java.io.IOException;

import org.apache.http.HttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class MeasurablePoolingHttpClientConnectionManager
    extends PoolingHttpClientConnectionManager
{
    //CSOFF: ParameterNumber
    @Override
    public void connect(
            final HttpClientConnection managedConn,
            final HttpRoute route,
            final int connectTimeout,
            final HttpContext context) throws IOException
    {
        Measurer m = Measurer.getMeasurer(context);

        if (m != null) {
            m.snapshot(Measurer.Event.BEFORE_CONNECT);
        }

        super.connect(managedConn, route, connectTimeout, context);

        if (m != null) {
            m.snapshot(Measurer.Event.AFTER_CONNECT);
        }
    }
    //CSON: ParameterNumber
}

