package ru.yandex.http.util.request;

import java.text.ParseException;
import java.util.function.Predicate;

import ru.yandex.collection.Pattern;
import ru.yandex.function.GenericFunction;
import ru.yandex.function.TruePredicate;
import ru.yandex.parser.config.ConfigException;

public enum RequestPatternParser
    implements GenericFunction<String, Pattern<RequestInfo>, ConfigException>
{
    INSTANCE;

    // CSOFF: FinalParameters
    @Override
    public Pattern<RequestInfo> apply(String uri)
        throws ConfigException
    {
        int conditionStart = uri.indexOf('{');
        Predicate<RequestInfo> predicate;
        if (conditionStart == -1) {
            predicate = TruePredicate.instance();
        } else {
            if (uri.charAt(uri.length() - 1) != '}') {
                throw new ConfigException(
                    "Unterminated condition: " + uri);
            }
            String condition =
                uri.substring(conditionStart + 1, uri.length() - 1);
            try {
                predicate =
                    RequestInfoPredicateParser.INSTANCE.apply(condition);
            } catch (ParseException e) {
                throw new ConfigException(
                    "Failed to parse condition: " + condition,
                    e);
            }
            uri = uri.substring(0, conditionStart);
        }
        boolean prefix = uri.charAt(uri.length() - 1) == '*';
        if (prefix) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return new Pattern<>(uri, prefix, predicate);
    }
    // CSON: FinalParameters
}

