package ru.yandex.http.util.request.function;

import org.apache.http.HttpRequest;

import ru.yandex.parser.uri.CgiParamsBase;
import ru.yandex.parser.uri.ScanningCgiParams;

public class BasicRequestFunctionContext implements RequestFunctionContext {
    protected final HttpRequest request;

    public BasicRequestFunctionContext(final HttpRequest request) {
        this.request = request;
    }

    @Override
    public HttpRequest request() {
        return request;
    }

    @Override
    public CgiParamsBase params() {
        return new ScanningCgiParams(request);
    }
}
