package ru.yandex.http.util.request.function;

import java.text.ParseException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;

public class ConcatFunction<V extends RequestFunctionContext>
    implements RequestFunction<V>
{
    private final RequestFunction<V>[] args;

    public ConcatFunction(final RequestFunction<V>[] args)
        throws ParseException
    {
        if (args.length == 0) {
            throw new ParseException("To few arguments to \"concat\"", 0);
        }
        this.args = args.clone();
    }

    @Override
    public RequestFunctionValue value(final V context)
        throws ExecutionException
    {
        final StringBuilder sb = new StringBuilder();
        for (RequestFunction<V> func: args) {
            sb.append(func.value(context).stringValue());
        }
        return new StringValue(new String(sb));
    }

    @Override
    public String toString() {
        return "concat(" + Arrays.toString(args) + ')';
    }
}
