package ru.yandex.http.util.request.function;

public class ConstFunction<V extends RequestFunctionContext>
    implements RequestFunction<V>
{
    private final RequestFunctionValue value;

    public ConstFunction(final String value) {
        this.value = new StringValue(value);
    }

    public ConstFunction(final long value) {
        this.value = new LongValue(value);
    }

    @Override
    public RequestFunctionValue value(final V context) {
        return value;
    }

    @Override
    public String toString() {
        return "const(" + value + ')';
    }
}
