package ru.yandex.http.util.request.function;

import java.util.concurrent.ExecutionException;

public class DoubleValue implements RequestFunctionValue {
    private final double value;

    public DoubleValue(final double value) {
        this.value = value;
    }

    public DoubleValue(final RequestFunctionValue value)
        throws ExecutionException
    {
        this.value = value.doubleValue();
    }

    @Override
    public int weight() {
        return Double.BYTES;
    }

    @Override
    public String stringValue() {
        return Double.toString(value);
    }

    @Override
    public long longValue() {
        return (long) value;
    }

    @Override
    public double doubleValue() {
        return value;
    }

    @Override
    public boolean booleanValue() {
        return value != 0;
    }

    @Override
    public String toString() {
        return "DoubleValue(" + value + ')';
    }

    @Override
    public int hashCode() {
        return Double.hashCode(value);
    }

    @Override
    public boolean equals(final Object o) {
        return this == o
            || (o instanceof DoubleValue && value == ((DoubleValue) o).value);
    }

    @Override
    public boolean equalsString(final String value) {
        return stringValue().equals(value);
    }
}
