package ru.yandex.http.util.request.function;

import java.text.ParseException;
import java.util.concurrent.ExecutionException;

public class GetFunction<V extends RequestFunctionContext>
    implements RequestFunction<V>
{
    private final RequestFunction<V> name;
    private final RequestFunction<V> defaultValue;

    public GetFunction(final RequestFunction<V>[] args)
        throws ParseException
    {
        if (args.length < 1 || args.length > 2) {
            throw new ParseException(
                "Invalid argument count to \"get\""
                + ": " + args.length + ", Usage: "
                + "get(name,[optional default value])", 0);
        }
        this.name = args[0];
        if (args.length == 2) {
            defaultValue = args[1];
        } else {
            defaultValue = new ConstFunction<V>("");
        }
    }

    @Override
    public RequestFunctionValue value(final V context)
        throws ExecutionException
    {
        String name = this.name.value(context).stringValue();
        String value = context.params().getString(name, null);
        if (value == null) {
            value = defaultValue.value(context).stringValue();
        }
        return new StringValue(value);
    }

    @Override
    public String toString() {
        return "get(" + name + ',' + defaultValue + ')';
    }
}
