package ru.yandex.http.util.request.function;

import java.text.ParseException;
import java.util.concurrent.ExecutionException;

public class GetOrNullFunction<V extends RequestFunctionContext>
    implements RequestFunction<V>
{
    private final RequestFunction<V> name;

    public GetOrNullFunction(final RequestFunction<V>[] args)
        throws ParseException
    {
        if (args.length != 1) {
            throw new ParseException(
                "Invalid argument count to \"get-or-null\""
                + ": " + args.length + ", Usage: "
                + "get-or-null(name)",
                0);
        }
        name = args[0];
    }

    @Override
    public RequestFunctionValue value(final V context)
        throws ExecutionException
    {
        String name = this.name.value(context).stringValue();
        String value = context.params().getString(name, null);
        if (value == null) {
            return null;
        } else {
            return new StringValue(value);
        }
    }

    @Override
    public String toString() {
        return "get-or-null(" + name + ')';
    }
}
