package ru.yandex.http.util.request.function;

import ru.yandex.parser.uri.UriParser;

public class GetPathFunction<V extends RequestFunctionContext>
    implements RequestFunction<V>
{
    public GetPathFunction() {
    }

    @Override
    public RequestFunctionValue value(final V context) {
        return
            new StringValue(
                new UriParser(context.request().getRequestLine().getUri())
                    .path()
                    .decodeOrRaw());
    }

    @Override
    public String toString() {
        return "get-path()";
    }
}
