package ru.yandex.http.util.request.function;

import java.text.ParseException;
import java.util.concurrent.ExecutionException;

public class HashFunction<V extends RequestFunctionContext>
    implements RequestFunction<V>
{
    private static final long LONG_MASK = 0xffffffffL;

    private final RequestFunction<V> value;

    public HashFunction(final RequestFunction<V>[] args)
        throws ParseException
    {
        if (args.length != 1) {
            throw new ParseException(
                "Function \"hash\" accepts exactly 1 argument",
                0);
        }
        value = args[0];
    }

    @Override
    public RequestFunctionValue value(final V context)
        throws ExecutionException
    {
        return new LongValue(value.value(context).hashCode() & LONG_MASK);
    }

    @Override
    public String toString() {
        return "hash(" + value + ')';
    }
}
