package ru.yandex.http.util.request.function;

import java.util.List;

import org.apache.http.HttpHost;

public class HostListValue implements RequestFunctionValue {
    private final List<HttpHost> value;

    public HostListValue(final List<HttpHost> value) {
        this.value = value;
    }

    @Override
    public int weight() {
        return (value.toString().length() << 1) + OBJECT_WEIGHT * value.size();
    }

    @Override
    public String stringValue() {
        return value.toString();
    }

    @Override
    public List<HttpHost> hostListValue() {
        return value;
    }

    @Override
    public String toString() {
        return "HostListValue(" + value + ')';
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        return this == o
            || (o instanceof HostListValue
                && value.equals(((HostListValue) o).value));
    }

    @Override
    public boolean equalsString(final String value) {
        return stringValue().equals(value);
    }
}
