package ru.yandex.http.util.request.function;

import java.net.InetAddress;

public class InetAddressValue implements RequestFunctionValue {
    private final InetAddress value;

    public InetAddressValue(final InetAddress value) {
        this.value = value;
    }

    @Override
    public int weight() {
        return value.getAddress().length + (OBJECT_WEIGHT << 1);
    }

    @Override
    public String stringValue() {
        return value.getHostAddress();
    }

    @Override
    public String toString() {
        return "InetAddressValue(" + stringValue() + ')';
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        return this == o
            || (o instanceof InetAddressValue
                && value.equals(((InetAddressValue) o).value));
    }

    @Override
    public boolean equalsString(final String value) {
        return stringValue().equals(value);
    }
}

