package ru.yandex.http.util.request.function;

public class LongValue implements RequestFunctionValue {
    private final long value;

    public LongValue(final long value) {
        this.value = value;
    }

    @Override
    public int weight() {
        return Long.BYTES;
    }

    @Override
    public String stringValue() {
        return Long.toString(value);
    }

    @Override
    public long longValue() {
        return value;
    }

    @Override
    public double doubleValue() {
        return value;
    }

    @Override
    public boolean booleanValue() {
        return value != 0L;
    }

    @Override
    public String toString() {
        return "LongValue(" + value + ')';
    }

    @Override
    public int hashCode() {
        return Long.hashCode(value);
    }

    @Override
    public boolean equals(final Object o) {
        return this == o
            || (o instanceof LongValue && value == ((LongValue) o).value);
    }

    @Override
    public boolean equalsString(final String value) {
        try {
            return this.value == Long.parseLong(value);
        } catch (RuntimeException e) {
            return false;
        }
    }
}
